// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/url_loader.mojom
//

package org.chromium.mojom.mojo;

public final class UrlResponse extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 96;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(96, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public NetworkError error;
    public org.chromium.mojo.system.DataPipe.ConsumerHandle body;
    public String url;
    public String site;
    public int statusCode;
    public String statusLine;
    public HttpHeader[] headers;
    public String mimeType;
    public String charset;
    public String redirectMethod;
    public String redirectUrl;
    public String redirectReferrer;

    private UrlResponse(int version) {
        super(STRUCT_SIZE, version);
        body = org.chromium.mojo.system.InvalidHandle.INSTANCE;
    }

    public UrlResponse() {
        this(0);
    }

    public static UrlResponse deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static UrlResponse decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        UrlResponse result = new UrlResponse(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
            result.error = NetworkError.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.body = decoder0.readConsumerHandle(16, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.statusCode = decoder0.readInt(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.url = decoder0.readString(24, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.site = decoder0.readString(32, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.statusLine = decoder0.readString(40, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
            if (decoder1 == null) {
                result.headers = null;
            } else {
                org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.headers = new HttpHeader[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    result.headers[i1] = HttpHeader.decode(decoder2);
                }
            }
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.mimeType = decoder0.readString(56, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.charset = decoder0.readString(64, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.redirectMethod = decoder0.readString(72, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.redirectUrl = decoder0.readString(80, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.redirectReferrer = decoder0.readString(88, true);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(error, 8, true);
        encoder0.encode(body, 16, true);
        encoder0.encode(statusCode, 20);
        encoder0.encode(url, 24, true);
        encoder0.encode(site, 32, true);
        encoder0.encode(statusLine, 40, true);
        if (headers == null) {
            encoder0.encodeNullPointer(48, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(headers.length, 48, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < headers.length; ++i0) {
                encoder1.encode(headers[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        encoder0.encode(mimeType, 56, true);
        encoder0.encode(charset, 64, true);
        encoder0.encode(redirectMethod, 72, true);
        encoder0.encode(redirectUrl, 80, true);
        encoder0.encode(redirectReferrer, 88, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        UrlResponse other = (UrlResponse) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.error, other.error))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.body, other.body))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.url, other.url))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.site, other.site))
            return false;
        if (this.statusCode != other.statusCode)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.statusLine, other.statusLine))
            return false;
        if (!java.util.Arrays.deepEquals(this.headers, other.headers))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mimeType, other.mimeType))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.charset, other.charset))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.redirectMethod, other.redirectMethod))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.redirectUrl, other.redirectUrl))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.redirectReferrer, other.redirectReferrer))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(error);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(body);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(url);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(site);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(statusCode);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(statusLine);
        result = prime * result + java.util.Arrays.deepHashCode(headers);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mimeType);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(charset);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(redirectMethod);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(redirectUrl);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(redirectReferrer);
        return result;
    }
}

